package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portlet.PortletURLFactoryUtil;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalExtensionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalPriorityTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalStatusTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalTaskRepetitionCycleTypeEnum;
import gov.va.med.mhv.mrp.enums.HourEnumeration;
import gov.va.med.mhv.mrp.enums.MinuteEnumeration;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalDTOConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalExtensionsDTOConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalTaskDTOConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@RequestScoped
public class CreateGoalController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(CreateGoalController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalConverter}")
	private MyGoalConverter myGoalConverter;

	@ManagedProperty("#{myGoalDTOConverter}")
	private MyGoalDTOConverter myGoalDTOConverter;

	@ManagedProperty("#{myGoalExtensionsDTOConverter}")
	private MyGoalExtensionsDTOConverter myGoalExtensionsDTOConverter;

	@ManagedProperty("#{myGoalTaskDTOConverter}")
	private MyGoalTaskDTOConverter myGoalTaskDTOConverter;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	@ManagedProperty("#{param.goalId}")
	private Long goalId;

	private String extension;

	private MyGoalTask myGoalTask;

	private MyGoal goal = new MyGoal();

	@PostConstruct
	public void postConstruct() {
		log.debug("@PostConstruct");
		log.debug("param.goalId= " + goalId + ", goal.goalId= " + goal.getGoalId() + ", userProfileId= " + userProfile.getUserProfileId());
		
		if (goalId != null && goalId != 0) {
			loadModel();
			// set default for tasks
			createGoalTask();
		} else {
			log.warn("Invalid parameters - missing goalId");
		}

	}

	private void loadModel() {
		MyGoalDTO dto = myGoalsWebServiceProxy.getMyGoalById(userProfile.getUserProfileId(), goalId);

		goal = myGoalConverter.convert(dto);
	}

	private void createGoalTask() {
		log.debug("createGoalTask");

		if (myGoalTask == null) {
			log.debug("setting defaults");
			myGoalTask = new MyGoalTask();
			myGoalTask.setStartDate(new Date());
			myGoalTask.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
			myGoalTask.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
			myGoalTask.setStatus(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
			myGoalTask.setOplock(0);
		}
	}

	public String saveAndGotoPage(String nextPage) {
		log.debug("saveAndGotoPage " + nextPage);

		if (saveGoal()) {
			return nextPage;
		} else {
			return null;
		}
	}

	public String previousPage(String nextPage) {
		if (nextPage.equalsIgnoreCase("create_goal_page4C") && (goal.getObstacles() == null || goal.getObstacles().isEmpty())) {
			return "create_goal_page3A";
		}

		return nextPage;
	}

	public void noSave() {
		// some pages have nothing to save but have a Save button anyway (I
		// guess for consistency)
		// use this method for those buttons
	}

	public void save() {
		log.debug(":: save ::");

		saveGoal();
	}

	private Boolean saveGoal() {
		Boolean success = false;

		log.debug(this);

		try {
			log.debug("Converting to DTO");
			MyGoalDTO myGoalDTO = myGoalDTOConverter.convert(goal);

			// set defaults for new record
			if (myGoalDTO.getGoalId() == null) {

				log.debug("creating new");
				myGoalDTO.setUserProfileId(userProfile.getUserProfileId());
				myGoalDTO.setStartDate(new Date());
				myGoalDTO.setOplock(0);
				myGoalDTO.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
				myGoalDTO.setPriorityType(GoalPriorityTypeEnumeration.OTHER.getCode());
				myGoalDTO.setStatus(GoalStatusTypeEnumeration.NOTCOMPLETE.getCode());
			}

			if (myGoalDTO.getCompletionType() == GoalCompletionTypeEnumeration.NOENDDATE.getCode()) {
				myGoalDTO.setEndDate(null);
			}

			log.debug("before save");
			MyGoalDTO resultDTO = new MyGoalDTO();
			try{
				log.debug("userid" + myGoalDTO.getUserProfileId());
				if (myGoalsWebServiceProxy == null){
					log.debug("WS null");
				}
				
				resultDTO = myGoalsWebServiceProxy.saveMyGoal(myGoalDTO.getUserProfileId(), myGoalDTO);
			} catch (Exception e){
				log.debug ("inside error ");
				log.debug(e.getMessage());
			}
			goal = null;
			goalId = null;
			log.debug("after save");

			goalId = resultDTO.getGoalId();
			log.debug("getting goal id:" + goalId);
 
			if (resultDTO != null) {
				if (log.isDebugEnabled()) {
					log.debug("return from save" + resultDTO);
				}

				goal = myGoalConverter.convert(resultDTO);
				log.debug("Total obstacles after save " + goal.getObstacles().size());

				success = true;
			}

		} catch (Exception e) {
			log.error(e);
		}

		if (!success) {
			log.debug("Save failed");
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
		}

		return success;
	}

	public void saveAndAddAnotherStrength() {
		log.debug("saveAndAddAnotherStrength :: ");
		log.debug("extension=" + extension);

		saveExtension(extension, GoalExtensionTypeEnumeration.STRENGTH);
	}

	public void updateStrength() {
		log.debug("saveAndAddAnotherStrength :: ");
		log.debug("extension=" + extension);

		saveExtension(extension, GoalExtensionTypeEnumeration.STRENGTH);
	}

	public String saveStrengthAndGotoPage(String nextPage) {
		log.debug("saveStrengthAndGotoPage " + nextPage);

		if (saveExtension(extension, GoalExtensionTypeEnumeration.STRENGTH)) {
			return nextPage;
		} else {
			return null;
		}
	}

	public void saveAndAddAnotherObstacle() {
		log.debug("saveAndAddAnotherObstacle :: ");
		log.debug("extension=" + extension);

		saveExtension(extension, GoalExtensionTypeEnumeration.OBSTACLE);
	}

	public String saveObstacleAndGotoPage(String nextPage) {
		log.debug("saveObstacleAndGotoPage " + nextPage);

		if (saveExtension(extension, GoalExtensionTypeEnumeration.OBSTACLE)) {
			// navigation rules
			if (goal.getObstacles() == null || goal.getObstacles().isEmpty()) {
				return "create_goal_page5";
			} else {
				return nextPage;
			}
		} else {
			return null;
		}
	}

	public void saveAndAddAnotherReward() {
		log.debug("saveAndAddAnotherReward :: " + goal);
		log.debug("extension=" + extension);

		saveExtension(extension, GoalExtensionTypeEnumeration.REWARD);
	}

	public String saveRewardAndGotoPage(String nextPage) {
		log.debug("saveRewardAndGotoPage " + nextPage);

		if (saveExtension(extension, GoalExtensionTypeEnumeration.REWARD)) {
			return nextPage;
		} else {
			return null;
		}
	}

	private boolean saveExtension(String ext, GoalExtensionTypeEnumeration goalExtensionTypeEnum) {
		boolean success = false;
		log.debug("saveExtension :: " + goal);
		log.debug("Extension=" + ext);

		try {

			if (ext != null && !ext.isEmpty()) {

				MyGoalsExtensionDTO dto = new MyGoalsExtensionDTO();

				dto.setDescription(ext);
				dto.setGoalExtensionType(goalExtensionTypeEnum.getCode());

				log.debug("Saving extension");

				MyGoalsExtensionDTO resultDTO = myGoalsWebServiceProxy.addMyGoalsExtension(goalId, dto);

				log.debug("return from save");

				if (resultDTO == null) {
					log.warn("Save failed");
					FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
				} else {
					log.debug(resultDTO);
					extension = "";
					loadModel();
				}
			}

			success = true;
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
		}

		return success;
	}

	public void deleteExtension(Long goalExtensionId) {

		log.debug("Deleting extension id=" + goalExtensionId);

		Response r = myGoalsWebServiceProxy.deleteMyGoalsExtension(goalExtensionId);

		if (r.getStatus() != Status.OK.getStatusCode()) {
			log.error("delete failed");
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "delete failed", "delete failed"));
		} else {
			log.debug("Delete successful");
			loadModel();
		}

	}

	public void saveAndAddAnotherTask() {

		try {

			log.debug(myGoalTask);

			log.debug("Converting to DTO");
			MyGoalTaskDTO myGoalTaskDTO = myGoalTaskDTOConverter.convert(myGoalTask);

			log.debug(myGoalTaskDTO);

			log.debug("Saving");
			MyGoalTaskDTO resultDTO = myGoalsWebServiceProxy.addMyGoalTask(myGoalTask.getGoalExtensionId(), myGoalTaskDTO);

			if (resultDTO == null) {
				log.warn("Save failed");
				FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
			} else {
				log.debug("Save successful " + resultDTO);
				myGoalTask = null;
				createGoalTask();
				loadModel();
			}

		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
		}

	}

	public void moveObstacleUp(MyGoalsExtension obstacle) {
		log.debug(obstacle);

		List<MyGoalsExtension> list = goal.getObstacles();

		if (list == null || list.isEmpty()) {
			return;
		}

		// swap seqNo
		int index = list.indexOf(obstacle);

		if (index == 0 || index == -1) {
			// already at the top of list, or not found
			return;
		}

		MyGoalsExtension swap = list.get(index - 1);
		Integer seqNo = swap.getGoalExtensionSequenceNumber();
		Integer seqNo2 = obstacle.getGoalExtensionSequenceNumber();

		obstacle.setGoalExtensionSeqNo(seqNo);
		swap.setGoalExtensionSeqNo(seqNo2);

		saveGoal();
	}

	public void moveObstacleDown(MyGoalsExtension obstacle) {
		log.debug(obstacle);

		List<MyGoalsExtension> list = goal.getObstacles();

		if (list == null || list.isEmpty()) {
			return;
		}

		// swap seqNo
		int index = list.indexOf(obstacle);

		if (index == goal.getObstacles().size() - 1 || index == -1) {
			// already at the bottom of list, or not found
			return;
		}

		MyGoalsExtension swap = list.get(index + 1);
		Integer seqNo = swap.getGoalExtensionSequenceNumber();
		Integer seqNo2 = obstacle.getGoalExtensionSequenceNumber();

		obstacle.setGoalExtensionSeqNo(seqNo);
		swap.setGoalExtensionSeqNo(seqNo2);

		saveGoal();
	}

	public void moveObstacleTop(MyGoalsExtension obstacle) {
		log.debug(obstacle);

		List<MyGoalsExtension> list = goal.getObstacles();

		if (list == null || list.isEmpty()) {
			return;
		}

		int index = list.indexOf(obstacle);

		if (index == 0 || index == -1) {
			// already at the top of list, or not found
			return;
		}

		log.debug("before sequence");
		log.debug(goal);
		// resequence list

		obstacle.setGoalExtensionSeqNo(1);

		Integer seqNo = 2;
		for (Integer i = 0; i < list.size(); i++) {
			if (i != index) {
				list.get(i).setGoalExtensionSeqNo(seqNo++);
			}
		}
		log.debug("after sequence");
		log.debug(goal);

		saveGoal();
	}

	public void deleteObstacle(MyGoalsExtension obstacle) {
		
		log.debug("deleteObstacle goalExtensionId=" + obstacle.getGoalExtensionId());
		log.debug("Total obstacles before delete:" + goal.getMyGoalsExtensions().size());
		goal.getMyGoalsExtensions().remove(obstacle);
		log.debug("Total obstacles after delete:" + goal.getMyGoalsExtensions().size());
		saveGoal();
		
		log.debug("Leaving deleteObstacle - total size" +  goal.getMyGoalsExtensions().size());
		
	}

	public void moveTaskUp(MyGoalsExtension obstacle, MyGoalTask task) {
		log.debug("moveTaskUp, taskId=" + task.getTaskId());

		List<MyGoalTask> list = obstacle.getTasks();

		if (list == null || list.isEmpty()) {
			log.debug("Empty list");
			return;
		}

		// swap seqNo
		int index = list.indexOf(task);

		if (index == 0 || index == -1) {
			// already at the top of list, or not found
			log.debug("already at top or missing from list");
			return;
		}

		MyGoalTask swap = list.get(index - 1);
		Integer seqNo = swap.getTaskSequenceNumber();
		Integer seqNo2 = task.getTaskSequenceNumber();

		if (log.isDebugEnabled()) {
			log.debug("before sequence");
			for (MyGoalTask t : obstacle.getTasks()) {
				log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
			}
		}

		log.debug("Swapping task" + task.getTaskId() + ", sequence=" + task.getTaskSequenceNumber());
		log.debug("Swapping task" + swap.getTaskId() + ", sequence=" + swap.getTaskSequenceNumber());

		task.setTaskSequenceNumber(seqNo);
		swap.setTaskSequenceNumber(seqNo2);

		if (log.isDebugEnabled()) {
			log.debug("after sequence");
			for (MyGoalTask t : obstacle.getTasks()) {
				log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
			}
		}

		saveObstacle(obstacle);
		// saveGoal();
	}

	public void moveTaskDown(MyGoalsExtension obstacle, MyGoalTask task) {
		log.debug("moveTaskDown, taskId=" + task.getTaskId());

		List<MyGoalTask> list = obstacle.getTasks();

		if (list == null || list.isEmpty()) {
			log.debug("Empty list");
			return;
		}

		// swap seqNo
		int index = list.indexOf(task);

		if (index == obstacle.getTasks().size() - 1 || index == -1) {
			// already at the bottom of list, or not found
			log.debug("already at bottom or missing from list");
			return;
		}

		MyGoalTask swap = list.get(index + 1);
		Integer seqNo = swap.getTaskSequenceNumber();
		Integer seqNo2 = task.getTaskSequenceNumber();

		if (log.isDebugEnabled()) {
			log.debug("before sequence");
			for (MyGoalTask t : obstacle.getTasks()) {
				log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
			}
		}

		log.debug("Swapping task" + task.getTaskId() + ", sequence=" + task.getTaskSequenceNumber());
		log.debug("Swapping task" + swap.getTaskId() + ", sequence=" + swap.getTaskSequenceNumber());

		task.setTaskSequenceNumber(seqNo);
		swap.setTaskSequenceNumber(seqNo2);

		if (log.isDebugEnabled()) {
			log.debug("after sequence");
			for (MyGoalTask t : obstacle.getTasks()) {
				log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
			}
		}

		saveObstacle(obstacle);
		// saveGoal();
	}

	public void moveTaskToTop(MyGoalsExtension obstacle, MyGoalTask task) {
		log.debug("moveTaskToTop, taskId=" + task.getTaskId());

		List<MyGoalTask> list = obstacle.getTasks();

		if (list == null || list.isEmpty()) {
			return;
		}

		int index = list.indexOf(task);

		if (index == 0 || index == -1) {
			// already at the top of list, or not found
			return;
		}

		if (log.isDebugEnabled()) {
			log.debug("before sequence");
			for (MyGoalTask t : obstacle.getTasks()) {
				log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
			}
		}

		Integer topSeqno = list.get(0).getTaskSequenceNumber();

		// shuffle other tasks down one spot and move this task to top spot
		for (Integer i = 0; i < index; i++) {
			list.get(i).setTaskSequenceNumber(list.get(i + 1).getTaskSequenceNumber());
		}
		task.setTaskSequenceNumber(topSeqno);

		if (log.isDebugEnabled()) {
			log.debug("after sequence");
			for (MyGoalTask t : obstacle.getTasks()) {
				log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
			}
		}

		// saveGoal();
		saveObstacle(obstacle);
	}

	private boolean saveObstacle(MyGoalsExtension obstacle) {
		boolean success = false;
		log.debug("saving MyGoalsExtension, goalExtensionId=" + obstacle.getGoalExtensionId());

		try {
			MyGoalsExtensionDTO dto = myGoalExtensionsDTOConverter.convert(obstacle);

			log.debug("Saving extension");
			if (log.isDebugEnabled()) {
				log.debug("before save");
				log.debug("Total Task count: " + dto.getMyGoalsTasks().size());
				for (MyGoalTaskDTO t : dto.getMyGoalsTasks()) {
					log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
				}
			}

			MyGoalsExtensionDTO resultDTO = myGoalsWebServiceProxy.addMyGoalsExtension(goalId, dto);
			log.debug("return from save");

			if (resultDTO == null) {
				log.warn("Save failed");
				FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
			} else {
				if (log.isDebugEnabled()) {
					log.debug("after save");
					log.debug("Total Task count after save: " + dto.getMyGoalsTasks().size());
					for (MyGoalTaskDTO t : resultDTO.getMyGoalsTasks()) {
						log.debug("taskId=" + t.getTaskId() + ", taskName=" + t.getTaskName() + ", taskSeqNo=" + t.getTaskSequenceNumber());
					}
				}

				loadModel();
			}

			success = true;
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
		}

		return success;
	}

	public void deleteTask(MyGoalsExtension obstacle, MyGoalTask task) {
		
		int index = goal.getMyGoalsExtensions().indexOf(obstacle);
		log.debug("Deleting taskId=" + task.getTaskId());
		log.debug(task);

		log.debug("Total tasks before delete: "+ obstacle.getTasks().size());
		obstacle.getTasks().remove(task);
		log.debug("Total tasks after delete: "+ obstacle.getTasks().size());
		goal.getMyGoalsExtensions().set(index, obstacle);
		
		saveGoal();
		
		log.debug("Total tasks after save: "+ obstacle.getTasks().size());
	}
	
	public String getViewGoalURL(String goalId) {
		String url = "";
		
		try {
			PortletRequest portletRequest = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			ServiceContext serviceContext = ServiceContextFactory.getInstance(portletRequest);
			String portletId = serviceContext.getPortletId();
			long plid = serviceContext.getPlid();
			String lifecycle = PortletRequest.RENDER_PHASE;
						
			List<Portlet> list = PortletLocalServiceUtil.getPortlets();
			for (Portlet p : list) {
				if (p.getPortletName().equalsIgnoreCase("myGoalsViewAndTrackGoals")) {
					portletId = p.getPortletId();
					log.debug("found=" + portletId);
					break;
				}
			}
			
			LiferayPortletURL portletURL = PortletURLFactoryUtil.create(portletRequest, portletId, plid, lifecycle);
			portletURL.setWindowState(WindowState.NORMAL);
			portletURL.setPortletMode(PortletMode.VIEW);
			portletURL.setParameter("_facesViewIdRender", "/views/trackgoals/viewgoal.xhtml");
			portletURL.setParameter("goalId", goalId);
			
			url = portletURL.toString();
			
			url = url.replace("create-a-goal", "view-and-track-my-goals");
			
		} catch (Exception e) {
			log.debug(e);
		}
		
		return url;
	}

	public HourEnumeration[] getHours() {
		return HourEnumeration.values();
	}

	public MinuteEnumeration[] getMinutes() {
		return MinuteEnumeration.values();
	}

	public MyGoal getGoal() {
		return goal;
	}

	public void setGoal(MyGoal goal) {
		this.goal = goal;
	}

	public MyGoalTask getMyGoalTask() {
		return myGoalTask;
	}

	public void setMyGoalTask(MyGoalTask myGoalTask) {
		this.myGoalTask = myGoalTask;
	}

	public Long getGoalId() {
		return goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalConverter(MyGoalConverter myGoalConverter) {
		this.myGoalConverter = myGoalConverter;
	}

	public MyGoalExtensionsDTOConverter getMyGoalExtensionsDTOConverter() {
		return myGoalExtensionsDTOConverter;
	}

	public void setMyGoalExtensionsDTOConverter(MyGoalExtensionsDTOConverter myGoalExtensionsDTOConverter) {
		this.myGoalExtensionsDTOConverter = myGoalExtensionsDTOConverter;
	}

	public void setMyGoalDTOConverter(MyGoalDTOConverter myGoalDTOConverter) {
		this.myGoalDTOConverter = myGoalDTOConverter;
	}

	public void setMyGoalTaskDTOConverter(MyGoalTaskDTOConverter myGoalTaskDTOConverter) {
		this.myGoalTaskDTOConverter = myGoalTaskDTOConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	@Override
	public String toString() {
		return "CreateGoalController [goalId=" + goalId + ", extension=" + extension + ", myGoalTask=" + myGoalTask + ", goal=" + goal + "]";
	}

}
